#!/bin/bash

actzTrace "XSETNETT: editFirewallChainByDest $*"

op=$1
sourceAddr=$2
sourceAddrMask=$3
destAddr=$4
destAddrMask=$5
protocol=$6
port=$7

if [ -x /sbin/iptables ]; then
    iptables=/sbin/iptables
elif [ -x /usr/sbin/iptables ]; then
    iptables=/usr/sbin/iptables
else
    actzTrace "XSETNETF: editFirewallChainByDest: No iptables executable found."
    exit 0
fi

# Check to see if the chain has been created yet
if $iptables -L -n | grep "HMC-INPUT-BY-DEST"; then
    actzTrace "XSETNETF: found the chain.. no need to created it"
else
    actzTrace "XSETNETF: creating HMC-INPUT-BY-DEST chain"
    $iptables --new HMC-INPUT-BY-DEST && \
    $iptables --insert INPUT --jump HMC-INPUT-BY-DEST
    rc=$?
    if [ "$rc" != "0" ]; then
        actzTrace "XSETNETF: error creating chain: $rc"
    fi
fi

if [ "$protocol" = "icmp" ]; then
    cmd="$iptables $op HMC-INPUT-BY-DEST --source $sourceAddr/$sourceAddrMask --destination $destAddr/$destAddrMask --protocol icmp --icmp-type $port --jump ACCEPT --verbose"
elif echo $port | grep ","; then
    # there are multiple ports specified.. use the 'multiport' module
    cmd="$iptables $op HMC-INPUT-BY-DEST --match multiport $ifname --source $sourceAddr/$sourceAddrMask --destination $destAddr/$destAddrMask --protocol $protocol --destination-ports $port --jump ACCEPT --verbose"
else
    cmd="$iptables $op HMC-INPUT-BY-DEST --source $sourceAddr/$sourceAddrMask --destination $destAddr/$destAddrMask --protocol $protocol --destination-port $port --jump ACCEPT --verbose"
fi

actzTrace "XSETNETF: executing cmd: '$cmd'"

$cmd

rc=$?

actzTrace "XSETNETF: <- editFirewallChainByDest: rc=$rc"

exit $rc
